﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Exceptions;
using InfoWorld.EVS.CTSVAPI;

namespace BMS.VistaWorker.Writer.Concrete.CatchExceptions.Concrete
{
    class CatchEvsExceptions : CommonCatchExceptions
    {

        protected override void MapExceptions()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Abort();
                Retry();
                Stop();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                MapAbortFaultException<UnknownCodeSystem>();
                MapAbortFaultException<UnknownConceptCode>();
                MapAbortFaultException<UnknownLanguageCode>();
                MapAbortFaultException<UnknownMapName>();
                MapAbortFaultException<UnknownMimeTypeCode>();
                MapAbortFaultException<UnknownPropertyCode>();
                MapAbortFaultException<UnknownRelationQualifier>();
                MapAbortFaultException<UnknownRelationshipCode>();

            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void Retry()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                MapRetryFaultException<TimeoutError>();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void Stop()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                MapStopFaultException<AmbiguousMapRequest>();
                MapStopFaultException<BadlyFormedMatchText>();
                MapStopFaultException<InvalidExpansionContext>();
                MapStopFaultException<NoApplicableDesignationFound>();
                MapStopFaultException<UnableToMap>();
                MapStopFaultException<UnexpectedError>();
                MapStopFaultException<UnknownMatchAlgorithm>();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

    }
}
